/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.alkahestry;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import reliquary.compat.jei.alkahestry.AlkahestryRecipeCategory;
import reliquary.crafting.AlkahestryChargingRecipe;
import reliquary.init.ModItems;
import reliquary.items.AlkahestryTomeItem;
import reliquary.reference.Reference;

public class AlkahestryChargingRecipeCategory
extends AlkahestryRecipeCategory<AlkahestryChargingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("reliquary", "alkahestry_charging");
    private static final int INPUT_SLOT = 0;
    private static final int TOME_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private final IDrawable background;
    private final Component localizedName;

    public AlkahestryChargingRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, UID);
        this.background = guiHelper.createDrawable(new ResourceLocation(Reference.DOMAIN + "textures/gui/jei/backgrounds.png"), 0, 0, 95, 36);
        this.localizedName = new TranslatableComponent("jei.reliquary.recipe.alkahest_charging");
    }

    public Class<? extends AlkahestryChargingRecipe> getRecipeClass() {
        return AlkahestryChargingRecipe.class;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setIngredients(AlkahestryChargingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        NonNullList outputs = NonNullList.m_122779_();
        outputs.add((Object)recipe.m_8043_());
        outputs.add((Object)AlkahestryTomeItem.setCharge(new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get()), recipe.getChargeToAdd()));
        ingredients.setOutputs(VanillaTypes.ITEM, (List)outputs);
    }

    public void setRecipe(IRecipeLayout recipeLayout, AlkahestryChargingRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().init(1, true, 18, 0);
        recipeLayout.getItemStacks().init(2, false, 73, 9);
        List ingredientsInputs = ingredients.getInputs(VanillaTypes.ITEM);
        ItemStack input = (ItemStack)((List)ingredientsInputs.get(0)).get(0);
        ItemStack tome = (ItemStack)((List)ingredientsInputs.get(1)).get(0);
        ItemStack output = (ItemStack)((List)ingredients.getOutputs(VanillaTypes.ITEM).get(0)).get(0);
        recipeLayout.getItemStacks().set(0, input);
        recipeLayout.getItemStacks().set(1, tome);
        recipeLayout.getItemStacks().set(2, output);
    }

    public void draw(AlkahestryChargingRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        String chargeString = "+" + recipe.getChargeToAdd();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int stringWidth = fontRenderer.m_92895_(chargeString);
        fontRenderer.m_92883_(matrixStack, chargeString, (float)(((double)this.background.getWidth() - (double)stringWidth) / 2.0), 3.0f, -8355712);
    }
}

